#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

long long suma_elemenata(const std::vector<std::vector<long>>& ulaznaMatrica, int n, int m, int k, int l, int poz_i, int poz_j) {

    long long suma = 0;

    for (int i=poz_i; i<poz_i+k; i++) {
        for (int j=poz_j; j<poz_j+l; j++) {
            suma += ulaznaMatrica[i][j];
        }
    }

    return suma;
}

long long lepota_matrice(const std::vector<std::vector<long>>& ulaznaMatrica, int n, int m, int k, int l) {

    long long lepota = 0;

    for (int i=0; i<(n-k+1); i++) {
        for (int j=0; j<(m-l+1); j++) {
            lepota += suma_elemenata(ulaznaMatrica, n, m, k, l, i, j);
        }
    }

    return lepota;
}

int main()
{
    int N, M, K, L;

    // Ucitavanje podataka

    cin >> N >> M >> K >> L;

    std::vector<vector<long>> velikaMatrica(N, std::vector<long>(M, 0));
    std::vector<long> podaci;
    std::vector<long long> lepote;
    long broj;

    for (int i=0; i<N*M; i++) {
        cin >> broj;
        podaci.push_back(broj);
    }

    std::sort(podaci.begin(), podaci.end());

    // Logika

    do {
        velikaMatrica.clear();
        for (size_t i = 0; i < podaci.size(); ++i) {
            velikaMatrica[i / M][i % M] = podaci[i];
        }

        lepote.push_back(lepota_matrice(velikaMatrica, N, M, K, L));

    } while (std::next_permutation(podaci.begin(), podaci.end()));

    auto maxLepota = std::max_element(lepote.begin(), lepote.end());

    cout << *maxLepota << endl;

    return 0;
}